/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.ItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.ITNTFactory;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DetonatorItem
extends ItemCoFH
implements IMultiModeItem {
    protected static final Map<Block, ITNTFactory<? extends PrimedTnt>> TNT_MAP = new IdentityHashMap<Block, ITNTFactory<? extends PrimedTnt>>();
    protected static final int MAX_PRIMED = 16;

    public static void registerTNT(Block block, ITNTFactory<? extends PrimedTnt> factory) {
        if (block == null) {
            return;
        }
        TNT_MAP.put(block, factory);
    }

    public DetonatorItem(Item.Properties builder) {
        super(builder);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("primed"), (stack, world, living, seed) -> this.getMode(stack) == 0 && this.getPrimedCount(stack) > 0 ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("armed"), (stack, world, living, seed) -> this.getMode(stack) == 1 && this.getPrimedCount(stack) > 0 ? 1.0f : 0.0f);
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)StringHelper.getTextComponent((String)("info.thermal.detonator.use." + this.getMode(stack))).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.detonator.primed").m_130940_(ChatFormatting.GRAY).m_7220_((Component)StringHelper.getTextComponent((String)(" " + this.getPrimedCount(stack) + "/16")).m_130940_(this.getPrimedCount(stack) <= 0 ? ChatFormatting.RED : (this.getMode(stack) == 0 ? ChatFormatting.YELLOW : ChatFormatting.GREEN))));
        tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.detonator.use.sneak").m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)StringHelper.getTextComponent((String)("info.thermal.detonator.mode." + this.getMode(stack))).m_130940_(ChatFormatting.ITALIC));
        if (this.getPrimedCount(stack) > 0) {
            this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        }
    }

    protected boolean useDelegate(ItemStack stack, UseOnContext context) {
        if (this.getMode(stack) == 0) {
            return this.primeTNT(stack, context.m_43725_(), context.m_8083_(), context.m_43723_());
        }
        return this.detonateTNT(stack, context.m_43725_(), context.m_43723_());
    }

    protected boolean primeTNT(ItemStack stack, Level world, BlockPos pos, Player player) {
        if (player == null || world.m_46859_(pos)) {
            return false;
        }
        if (TNT_MAP.containsKey(world.m_8055_(pos).m_60734_())) {
            ListTag primedTNT = stack.m_41784_().m_128437_("Primed", 10);
            CompoundTag tntPos = NbtUtils.m_129224_((BlockPos)pos);
            if (primedTNT.size() >= 16 || primedTNT.contains((Object)tntPos)) {
                return false;
            }
            primedTNT.add((Object)tntPos);
            stack.m_41784_().m_128365_("Primed", (Tag)primedTNT);
            return true;
        }
        return false;
    }

    protected boolean detonateTNT(ItemStack stack, Level world, Player player) {
        if (player == null) {
            return false;
        }
        if (Utils.isServerWorld((Level)world)) {
            ListTag primedTNT = stack.m_41784_().m_128437_("Primed", 10);
            for (int i = 0; i < primedTNT.size(); ++i) {
                BlockPos tntPos = NbtUtils.m_129239_((CompoundTag)primedTNT.m_128728_(i));
                this.attemptDetonate(world, tntPos, player, 0);
            }
            stack.m_41749_("Primed");
        }
        this.setMode(stack, 0);
        return true;
    }

    protected void attemptDetonate(Level world, BlockPos pos, Player player, int fuse) {
        if (!world.m_46749_(pos)) {
            return;
        }
        Block block = world.m_8055_(pos).m_60734_();
        if (TNT_MAP.containsKey(block)) {
            world.m_7471_(pos, false);
            PrimedTnt tnt = TNT_MAP.get(block).createTNT(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (LivingEntity)player);
            tnt.m_32085_(fuse);
            world.m_7967_((Entity)tnt);
            world.m_6263_(null, tnt.m_20185_(), tnt.m_20186_(), tnt.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected int getPrimedCount(ItemStack stack) {
        if (!stack.m_41782_()) {
            return 0;
        }
        ListTag primedTNT = stack.m_41783_().m_128437_("Primed", 10);
        return primedTNT.size();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        return player.m_36204_(context.m_8083_(), context.m_43719_(), context.m_43722_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        return player.m_36204_(context.m_8083_(), context.m_43719_(), stack) && this.useDelegate(stack, context) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_36341_()) {
            stack.m_41749_("Primed");
            player.m_5496_(SoundEvents.f_11871_, 0.5f, 0.3f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (this.getMode(stack) == 1 && this.detonateTNT(stack, world, player)) {
            player.m_6674_(hand);
            player.m_5496_(SoundEvents.f_12088_, 0.4f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public int getNumModes(ItemStack stack) {
        return this.getPrimedCount(stack) > 0 ? 2 : 1;
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_12088_, SoundSource.PLAYERS, 0.4f, 1.0f - 0.3f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.thermal.detonator.mode." + this.getMode(stack)));
    }
}

